import 'package:viserpay_agent/core/utils/method.dart';
import 'package:viserpay_agent/core/utils/url_container.dart';
import 'package:viserpay_agent/data/model/global/response_model/response_model.dart';
import 'package:viserpay_agent/data/services/api_service.dart';

class CashInRepo {
  ApiClient apiClient;
  CashInRepo({required this.apiClient});

  Future<ResponseModel> qrCodeScan(String code) async {
    String url = "${UrlContainer.baseUrl}${UrlContainer.qrScanEndPoint}";
    Map<String, String> params = {"code": code};
    ResponseModel responseModel = await apiClient.request(url, Method.postMethod, params, passHeader: true);
    return responseModel;
  }

  Future<dynamic> getCashoutData() async {
    String url = "${UrlContainer.baseUrl}${UrlContainer.cashInUrl}";
    ResponseModel responseModel = await apiClient.request(url, Method.getMethod, null, passHeader: true);

    return responseModel;
  }

  Future<ResponseModel> submitcashIn({required String walletId, required String amount, required String user, required String otpType}) async {
    String url = "${UrlContainer.baseUrl}${UrlContainer.submitCashInUrl}";

    Map<String, String> params = {"amount": amount, "user": user, "otp_type": otpType};

    ResponseModel responseModel = await apiClient.request(url, Method.postMethod, params, passHeader: true);
    return responseModel;
  }

  Future<ResponseModel> checkUser({required String user}) async {
    String url = "${UrlContainer.baseUrl}${UrlContainer.checkUserUrl}";
    Map<String, String> params = {"user": user};

    ResponseModel responseModel = await apiClient.request(url, Method.postMethod, params, passHeader: true);
    return responseModel;
  }
}
